define(['angular', 'app', 'formatter'], function (angular, app) {
	'use strict';

    app.controller('FitnessNotificationStatusController', function ($scope, $q, $state,
        $stateParams, FitnessRemindersService, focusService) {

        var detailsReady = $q.defer();
        
        $scope.sectionTitle = 'Fitness Activity';

		FitnessRemindersService.init('fitness-activity');
		FitnessRemindersService.getReminder().then(function (response) {
            $scope.details = angular.copy(response);
            detailsReady.resolve();
        });

        $scope.entryForm = {
            service: FitnessRemindersService,
            callbacks: {
                common: function () {
                    $state.go($state.current.data.backState, $stateParams);
                }
            },
            allowedActions: {
                save: true,
                cancel: true
            }
        };

        $scope.$watch('details.notificationStatus', function (status) {
            if (status !== "On" && $scope.details) {
                $scope.details.eventDate = "";
                $scope.details.frequency = "";
                $scope.details.times = [{value: ""}];
                $scope.details.notificationTypes = [];
            }
        });

		var onViewChange = function () {
			focusService.focusPrimary();
		};
		$scope.$on('$viewContentLoaded', onViewChange);
		$scope.$on('$stateChangeSuccess', onViewChange);
    });
});